#!/bin/sh
# script to start the dejagnu test for sh

TESTDIR=/view/dragon.sh-dejagnu/vobs/wpwr
SHDIR=/view/jimmyb.sh-dsp/vobs/wpwr
TOOL=g++

for arg
do
    case $arg in
	-i)	echo "instrument"; verbose='-instrument'; shift;
		continue;;
	-v)	echo "setting verbose"; verbose='-verbose'; shift;
		continue;;
	-vv)	echo "setting really verbose"; 
		verbose='-verbose -talkative'; 
		shift;
		continue;;
	g*)	TOOL=g++; break;;
	libi*)	TOOL=libio; break;;
	libs*)	TOOL=libstdc++; break;;
	*) echo "Unknown option $1"; exit 1;;
    esac
done

echo "rundeja -board t22-209 -x10 59 -tool $TOOL"
echo "	-registry mustaine"
echo "	-test $SHDIR"
echo "	-dejagnu $TESTDIR"
echo "	-kernel $SHDIR"
echo "	-windsh $SHDIR"
echo "	-tgtsvr $SHDIR" 
echo "	$verbose"

# exit 0

rundeja -board t22-209 -x10 59 -tool $TOOL -test $SHDIR -dejagnu $TESTDIR \
-kernel $SHDIR -windsh $SHDIR -tgtsvr $SHDIR -registry mustaine $verbose
